<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Qualiteam software Ltd <info@x-cart.com>
 * @copyright Copyright (c) 2011-2013 Qualiteam software Ltd <info@x-cart.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.x-cart.com/
 */

namespace XLite\Module\Baby\DropDown\Controller\Admin;


/**
 * Drop down controller
 */
class DropDown extends \XLite\Controller\Admin\AAdmin
{
    /**
     * FIXME- backward compatibility
     *
     * @var   array
     */
    protected $params = array('target', 'parent_id', 'root');

    /**
     * Check ACL permissions
     *
     * @return boolean
     */
    public function checkACL()
    {
        return parent::checkACL()
            || \XLite\Core\Auth::getInstance()->isPermissionAllowed('manage menus');
    }

    /**
     * Get current parent_id
     *
     * @return string
     */
    public function getParent_Id()
    {
        return \XLite\Core\Request::getInstance()->parent_id ?: \XLite\Module\Baby\DropDown\Model\DropDown::MENU_ROOT_PARENT;
    }

    /**
     * Get Root Level
     *
     * @return string 
     */
    public function getRootLevel()
    {
        return \XLite\Module\Baby\DropDown\Model\DropDown::MENU_ROOT_LEVEL;
    }

    /**
     * Get Root Level
     *
     * @return string 
     */
    public function getRoot()
    {
        return \XLite\Core\Request::getInstance()->root ?: \XLite\Module\Baby\DropDown\Model\DropDown::DROP_ROOT_PARENT;
    }

    /**
     * Get parent name
     *
     * @return string 
     */
    public function getParentName()
    {
        $parent_id = $this->getParent_Id();

        $parent = \XLite\Core\Database::getRepo('\XLite\Module\Baby\DropDown\Model\DropDown')->findOneById($parent_id);

        $parentName = $parent->name;

        return $parentName;
    }

   /**
     * Get root status
     *
     * @return string 
     */
    public function getRootStatus()
    {
        $root = $this->getRoot();
        
        if ($root == 'N')
            return true;

        if ($root != 'N')
            return false;
    }

    /**
     * Return the current page title (for the content area)
     *
     * @return string
     */
    public function getTitle()
    {
        return static::t('Drop down menu');
    }

    /**
     * Check if the option "Show default menu along with the custom one" is displayed
     *
     * @return boolean
     */
    public function isVisibleShowDefaultOption()
    {
        return false;
    }

    /**
     * Get pages templates
     *
     * @return array
     */
    /*protected function getPageTemplates()
    {
        $list = array();
        foreach (\XLite\Module\Baby\DropDown\Model\DropDown::getTypes() as $k => $v) {
            $list[$k] = 'modules/CDev/SimplerCMS/menus/body.tpl';
        }

        return $list;
    }*/

    /**
     * Update list
     *
     * @return void
     */
    protected function doActionUpdate()
    {
        $list = new \XLite\Module\Baby\DropDown\View\ItemsList\Model\DropDown;
        $list->processQuick();
    }

    // {{{ Search

    /**
     * Get search condition parameter by name
     *
     * @param string $paramName Parameter name
     *
     * @return mixed
     */
    public function getCondition($paramName)
    {
        $searchParams = $this->getConditions();

        return isset($searchParams[$paramName])
            ? $searchParams[$paramName]
            : null;
    }

    /**
     * Save search conditions
     *
     * @return void
     */
    protected function doActionSearch()
    {
        $cellName = \XLite\Module\Baby\DropDown\View\ItemsList\Model\DropDown::getSessionCellName();

        \XLite\Core\Session::getInstance()->$cellName = $this->getSearchParams();
    }

    /**
     * Return search parameters
     *
     * @return array
     */
    protected function getSearchParams()
    {
        $searchParams = $this->getConditions();

        foreach (
            \XLite\Module\Baby\DropDown\View\ItemsList\Model\DropDown::getSearchParams() as $requestParam
        ) {
            if (isset(\XLite\Core\Request::getInstance()->$requestParam)) {
                $searchParams[$requestParam] = \XLite\Core\Request::getInstance()->$requestParam;
            }
        }

        return $searchParams;
    }

    /**
     * Get search conditions
     *
     * @return array
     */
    protected function getConditions()
    {
        $cellName = \XLite\Module\Baby\DropDown\View\ItemsList\Model\DropDown::getSessionCellName();

        $searchParams = \XLite\Core\Session::getInstance()->$cellName;

        if (!is_array($searchParams)) {
            $searchParams = array();
        }

        return $searchParams;
    }

    // }}}

}
