<?php
// vim: set ts=4 sw=4 sts=4 et:

/**
 * X-Cart
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the software license agreement
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.x-cart.com/license-agreement.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to licensing@x-cart.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not modify this file if you wish to upgrade X-Cart to newer versions
 * in the future. If you wish to customize X-Cart for your needs please
 * refer to http://www.x-cart.com/ for more information.
 *
 * @category  X-Cart 5
 * @author    Qualiteam software Ltd <info@x-cart.com>
 * @copyright Copyright (c) 2011-2014 Qualiteam software Ltd <info@x-cart.com>. All rights reserved
 * @license   http://www.x-cart.com/license-agreement.html X-Cart 5 License Agreement
 * @link      http://www.x-cart.com/
 */

namespace XLite\Module\Baby\DropDown\View\ItemsList\Model;

/**
 * DropDown items list
 */
class DropDown extends \XLite\View\ItemsList\Model\Table
{
    /**
     * Get a list of CSS files required to display the widget properly
     *
     * @return array
     */
    public function getCSSFiles()
    {
        $list = parent::getCSSFiles();

        $list[] = 'modules/Baby/DropDown/drop_down/style.css';

        return $list;
    }
 
   /**
     * Get root status
     *
     * @return string 
     */
    public function getRootState()
    {
        $root = $this->getRoot();
        
        if ($root == 'Y')
            return true;

        if ($root != 'Y')
            return true;
    }

    /**
     * Define columns structure
     *
     * @return array
     */
    protected function defineColumns()
    {
        $columns = array(
            'name' => array(
                static::COLUMN_NAME         => static::t('Item name'),
                static::COLUMN_CLASS        => 'XLite\View\FormField\Inline\Input\Text',
                static::COLUMN_PARAMS       => array('required' => true),
                static::COLUMN_ORDERBY  => 100,
            ),
            'link' => array(
                static::COLUMN_NAME         => static::t('Link'),
                static::COLUMN_CLASS        => 'XLite\View\FormField\Inline\Input\Text',
                static::COLUMN_PARAMS       => array('required' => true),
                static::COLUMN_HEAD_HELP    => $this->getColumnLinkHelp(),
                static::COLUMN_ORDERBY  => 200,
            ),
            'visibleFor' => array(
                static::COLUMN_NAME         => static::t('Visible for'),
                static::COLUMN_CLASS        => 'XLite\Module\Baby\DropDown\View\FormField\VisibleFor',
                static::COLUMN_PARAMS       => array('fieldOnly' => true),
                static::COLUMN_ORDERBY  => 300,
            ),
            /*'id' => array(
                static::COLUMN_NAME          => static::t('Edit Submenu'),
                static::COLUMN_NO_WRAP => true,
                static::COLUMN_TEMPLATE      => 'modules/Baby/DropDown/itemslist/info.edit.tpl',
                static::COLUMN_ORDERBY       => 400,
            ),
            'id' => array(
                static::COLUMN_NAME    => \XLite\Core\Translation::lbl('Edit Submenu'),
                static::COLUMN_NO_WRAP => true,
                static::COLUMN_LINK    => 'drop_down',
                static::COLUMN_ORDERBY  => 400,
            ),*/
        );
        if ($this->getRootState()){
            $columns[id] = array(
                static::COLUMN_NAME          => static::t('Edit Submenu'),
                static::COLUMN_NO_WRAP => true,
                static::COLUMN_TEMPLATE      => 'modules/Baby/DropDown/itemslist/info.edit.tpl',
                static::COLUMN_ORDERBY       => 400,
            );
        }

        return $columns;
    }
 
    /**
     * Get message for 'link' column header help
     *
     * @return string
     */
    protected function getColumnLinkHelp()
    {
        return static::t('Menu links help text', array('URL' => $this->getShopURL()));
    }

    /**
     * Define repository name
     *
     * @return string
     */    
    protected function defineRepositoryName()
    {
        return 'XLite\Module\Baby\DropDown\Model\DropDown';
    }
 
    /**
     * Get create entity URL
     *
     * @return string
     */
    protected function getCreateURL()
    {
        return \XLite\Core\Converter::buildURL('drop_down');
    }

    /**
     * Get create button label
     *
     * @return string
     */
    protected function getCreateButtonLabel()
    {
        return 'New item';
    }
  
    /**
     * Inline creation mechanism position
     *
     * @return integer
     */
    protected function isInlineCreation()
    {
        return static::CREATE_INLINE_TOP;
    }


    // {{{ Behaviors

    /**
     * Mark list as removable
     *
     * @return boolean
     */
    protected function isRemoved()
    {
        return true;
    }

    /**
     * Mark list as switchable (enable / disable)
     *
     * @return boolean
     */
    protected function isSwitchable()
    {
        return true;
    }

    /**
     * Mark list as sortable
     *
     * @return integer
     */
    protected function getSortableType()
    {
        return static::SORT_TYPE_MOVE;
    }

    // }}}

    /**
     * Get container class
     *
     * @return string
     */
    protected function getContainerClass()
    {
        return parent::getContainerClass() . ' dropdown';
    }

    /**
     * Get panel class
     *
     * @return \XLite\View\Base\FormStickyPanel
     */
    /*protected function getPanelClass()
    {
        return 'XLite\Module\CDev\SimplerCMS\View\StickyPanel\ItemsList\Menu';
    }*/

    /**
     * Create entity
     *
     * @return \XLite\Model\AEntity
     */
    protected function createEntity()
    {
        $entity = parent::createEntity();

        $entity->setParent_Id($this->getParent_Id());

        $entity->setRoot($this->getRoot());

        return $entity;
    }

    // {{{ Search

    /**
     * Return search parameters.
     *
     * @return array
     */
    static public function getSearchParams()
    {
        return array();
    }

    /**
     * Return params list to use for search
     * TODO refactor
     *
     * @return \XLite\Core\CommonCell
     */
    protected function getSearchCondition()
    {
        $result = parent::getSearchCondition();

        foreach (static::getSearchParams() as $modelParam => $requestParam) {
            $paramValue = $this->getParam($requestParam);

            if ('' !== $paramValue && 0 !== $paramValue) {
                $result->$modelParam = $paramValue;
            }
        }

        $result->parent_id = $this->getParent_Id();

        $result->root = $this->getRoot();

        return $result;
    }

    /**
     * Get URL common parameters
     *
     * @return array
     */
    protected function getCommonParams()
    {
        $this->commonParams = parent::getCommonParams();
        $this->commonParams['parent_id'] = $this->getParent_Id();
        $this->commonParams['root'] = $this->getRoot();

        return $this->commonParams;
    }

    /**
     * Return name of the session cell identifier
     *
     * @return string
     */
    protected function getSessionCell()
    {
        return parent::getSessionCell() . $this->getParent_Id();
    }

    // }}}

}
