<?php
 
namespace XLite\Module\Baby\DropDown\View;
 
  
/**
 * @ListChild (list="layout.header.bar", zone="customer", weight="140")
 */
 
class DropDownMenu extends \XLite\View\AView
{
    /**
     * Get a list of CSS files required to display the widget properly
     *
     * @return array
     */
    public function getCSSFiles()
    {
        $list = parent::getCSSFiles();

        $list[] = 'modules/Baby/DropDown/css/dropdown.css';

        return $list;
    }

    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/Baby/DropDown/menu/body.tpl';
    }

    protected function getHead()
    {
        return 'Drop Down Menu';
    }
   
    protected function getDir()
    {
        return 'modules/Baby/DropDown/menu';
    }

    /*protected function getMenu()
    {
        return \XLite\Core\Database::getRepo('\XLite\Module\Baby\DropDown\Model\DropDown')->findBy(array('parent_id' => 1), array('position' => 'ASC'));
    }*/

    protected function getMenu()
    {
        $menu = array();
        $cnd = new \XLite\Core\CommonCell;
        $cnd->enabled = true;
        $cnd->root = 'Y';
        $cnd->visibleFor = array(
            'AL',
            (\XLite\Core\Auth::getInstance()->isLogged() ? 'L' : 'A'),
        );

        foreach (\XLite\Core\Database::getRepo('XLite\Module\Baby\DropDown\Model\DropDown')->search($cnd) as $v) {
            $menu[] = array(
                'url'    => $v->getLink(),
                'label'  => $v->getName(),
                'id'     => $v->getId(),
            );
        }

        return $menu;
    }

    /*protected function getSubs($parentid)
    {
        if($this->getRootStatus)
          return \XLite\Core\Database::getRepo('\XLite\Module\Baby\DropDown\Model\DropDown')->findBy(array('parent_id' => $parentid), array('position' => 'ASC'));

        if(!$this->getRootStatus)
          return NULL;

    }*/

    protected function getSubs($parentid)
    {
        $menu = array();
        $cnd = new \XLite\Core\CommonCell;
        $cnd->parent_id = $parentid;
        $cnd->enabled = true;
        $cnd->root = 'N';
        $cnd->visibleFor = array(
            'AL',
            (\XLite\Core\Auth::getInstance()->isLogged() ? 'L' : 'A'),
        );

        foreach (\XLite\Core\Database::getRepo('XLite\Module\Baby\DropDown\Model\DropDown')->search($cnd) as $v) {
            $menu[] = array(
                'url'    => $v->getLink(),
                'label'  => $v->getName(),
                'id'     => $v->getId(),
            );
        }

        return $menu;

    }

    protected function isParent($parentid)
    {
        if($parentid == 1)
          return true;

        if($parentid != 1)
          return false;
    }

    /**
     * Display item class as tag attribute
     *
     * @param integer $i Item index
     *
     * @return string
     */
    protected function showMenuClass($i)
    {
        $classes = array('leaf');

        if (0 == $i) {
            $classes[] = 'first';
        }

        if (count($this->getMenu()) == $i + 1) {
            $classes[] = 'last';
        }

        return $classes ? ' class="' . implode(' ', $classes) . '"' : '';
    }
}